﻿using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.OptionSets;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Create Provider Veteran Identifier step.
    /// </summary>
    public class CreateProviderVeteranIdentifierStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (string.IsNullOrEmpty(state.ProviderSite) || state.ExceptionOccured || state.Veteran == null) return;

            state.PatientAndProviderSitesAreEqual = state.PatientSite == state.ProviderSite;

            if (state.PatientAndProviderSitesAreEqual)
            {
                Logger.Instance.Debug("Provider and Patient Station Codes are the same, skip creating provider veteran identifier");
                return;
            }
            
            var veteranIdentifier = state.VeteranIdentifiers.FirstOrDefault(x => x.mcs_assigningfacility == state.ProviderSite);

            if (veteranIdentifier == null)
            {
                state.ProviderSideIdentifierToAdd = new mcs_personidentifiers()
                {
                    mcs_assigningauthority = "USVHA",
                    mcs_assigningfacility = state.ProviderSite,
                    mcs_identifier = "PROXY_VISTA",
                    mcs_identifiertype = new Microsoft.Xrm.Sdk.OptionSetValue((int)mcs_personidentifiersmcs_identifiertype.ParticipantIdentifier_PI),
                    mcs_name = string.Format("VistA Station {0} IEN", state.ProviderSite),
                    mcs_patient = new Microsoft.Xrm.Sdk.EntityReference(Contact.EntityLogicalName, state.Veteran.Id)
                };
            }
            else
            {
                Logger.Instance.Debug("Provider Site already in the Identifer list");
            }
        }
    }
}